///////////////////////////////////////////////////////
//                                                   //
//     Common JavaScript Layer Functions             // 
//                                                   //
///////////////////////////////////////////////////////
// void layerToFront(layerRef[,doc])                 //
// void getLayerZIndex(layerRef[,doc])               //
// void setLayerZIndex(layerRef, index[,doc])        //
// void hideLayer(layerRef[,doc])                    //
// void showLayer(layerRef[,doc])                    //
// bool getLayerVisibility(layerRef[,doc])           //
// void setLayerVisibility(layerRef,flag[,doc])      //
// void toggleLayerVisibility(layerRef[,doc])        //
// void moveLayer(layerRef,x,y[,doc])                //
// object getLayerRef(layerName[,doc])               //
// object getImageRef(imageName[,doc])               //
// int getLayerX(layerRef[,doc])                     //
// int getLayerY(layerRef[,doc])                     //
// int getLayerWidth(layerRef[,doc])                 //
// void setLayerWidth(layerRef,width[,doc])          //
// int getLayerHeight(layerRef[,doc])                //
// void setLayerHeight(layerRef,height[,doc])        //
// void setLayerSize(layerRef,width,height[,doc])    //
// object getImageRef(imageName[,doc])               //
// object getFormRef(formName[,doc])                 //
///////////////////////////////////////////////////////
//
//         INSTRUCTIONS
//
// To use the layer functions declared in this
// file, you first need to include this file in your 
// HTML source with a script tag in the head
// section of your document:
//
//   <script src="layers.js"></script>
//
// Only layers created with the DIV tag are
// supported. This version of layers.js will 
// work with:
//   IE 4.01 - 5.0
//   Netscape 4.5, 4.7, 6.0.
//
//////////////////////////////////////////////////////// 

var debugLayers = true;

var inNetscape45 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) < 5);
var inIe4 = (navigator.appName == "Microsoft Internet Explorer" && parseInt(navigator.appVersion) >= 4);
var inNetscape6 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) >= 5);
var unsupportedBrowser = (!(inNetscape45 || inIe4 || inNetscape6));
var recCount = -1;
var layerRefArray = null;

//alert("inNetscape45 :" + inNetscape45);
//alert("inIe4 :" + inIe4);
//alert("inNetscape6 :" + inNetscape6);

//findLayersNetscape6() is a helper that gets
//called in order to fill the layerRefArray[]
//with references to all of the DIV's
//in the specified document.  It is called
//by getTopzIndex().
//
//Netscape 6 only.
//

function setLayerZIndex(layerRef, index, doc)
{
	var tempLayerName = layerRef;

	if (setLayerZIndex.arguments.length < 3)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'setLayerZIndex()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, setLayerZIndex().");
		return;
	}
	
	if (inNetscape45) 
	{
		layerRef.zIndex = index;
	}
	else if (inNetscape6)
	{
		layerRef.style.zIndex = index;
	}
	else if (inIe4)
	{
		layerRef.style.zIndex = index;
	}
}

function getLayerZIndex(layerRef, doc)
{
	var tempLayerName = layerRef;

	if (getLayerZIndex.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'getLayerZIndex()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerZIndex().");
		return 0;
	}
	
	if (inNetscape45) 
	{
		return layerRef.zIndex;
	}
	else if (inNetscape6)
	{
		return layerRef.style.zIndex;
	}
	else if (inIe4)
	{
		return layerRef.style.zIndex;
	}
}

function findLayersNetscape6(doc)
{
	layerRefArray = new Array();
	findLayersNetscape6Rec(doc.body);
}

//findLayersNetscape6Rec() is called by findLayersNetscape6().
//It recurses through the DOM to find all layers, and
//places references to them in the layerRefArray.
//
//Netscape 6 only.
//
function findLayersNetscape6Rec(obj)
{
	for (var i in obj)
	{	
		if (i.toString() == "tagName" && obj[i] == "DIV")
		{	
			layerRefArray[layerRefArray.length] = obj;
		}
		if (i.toString() == "childNodes" && obj[i] != "null")
		{
			for (var t=0;t<obj[i].length;t++)
			{
				findLayersNetscape6(obj[i][t]);
			}
		}
	}
}

function getTopzIndex(doc)
{
	if (inNetscape45)
	{
		return zIndexFinder(0,doc);
	}
	else if (inNetscape6)
	{
		findLayersNetscape6(doc);
		var index = 0;
		for (var i=0;i<layerRefArray.length;i++)
		{
			if (layerRefArray[i].style.zIndex > index)
				index = layerRefArray[i].style.zIndex;
		}
		return index;
	}
	else if (inIe4)
	{
		var index=0;
		for (var i=0;i<doc.all.length;i++)
			if (doc.all[i].style.zIndex > index)
				index = doc.all[i].style.zIndex;
		return index;
	}
	else
	{
		alert("Your current browser, " + navigator.appName + ", is not supported.");
		return 0;
	}
}

//Recursive function used by Netscape 4.5 to
//find the highest zIndex for all of the
//layers in the document.  Gets called by 
//getTopzIndex().
function zIndexFinder(index,doc)
{
	for (i=0;i<doc.layers.length;i++) // for each layer in the document
	{
		// If this layer has a higher zIndex, then we keep that value.
		if (doc.layers[i].zIndex > index) 
		{
			index = doc.layers[i].zIndex;
		}
		
		// If this layer has nested layers inside it, lets check them also.
		if (doc.layers[i].document.layers.length > 0) 
		{
			index = zIndexFinder(index,doc.layers[i].document)
		}

	}
	
	return index;
}

function layerToFront(layerRef, doc)
{
	var tempLayerName = layerRef;
	if (layerToFront.arguments.length < 2)
	{
		doc = document;
	}

	var index = getTopzIndex(doc) + 1;
	layerRef = checkLayerRef(layerRef, "layerToFront", doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, layerToFront().");
		return;
	}

	if (inNetscape45) 
	{
		layerRef.zIndex = index;
	}
	else if (inNetscape6)
	{
		layerRef.style.zIndex = index;
	}
	else if (inIe4)
	{
		layerRef.style.zIndex = index;
	}
}

function hideLayer(layerRef, doc)
{ 
	var tempLayerName = layerRef;
	if (hideLayer.arguments.length < 2)
	{
		doc = document;
	}
	layerRef = checkLayerRef(layerRef, 'hideLayer()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, hideLayer().");
		return;
	}
	if (inNetscape45) 
	{
		layerRef.visibility = 'hide';
	}
	else if (inNetscape6)
	{
		layerRef.oldZIndex = getLayerZIndex(layerRef, doc);
		layerRef.style.visibility = 'hidden';
		setLayerZIndex(layerRef, 0, doc);
	}
	else if (inIe4)
	{
		layerRef.style.visibility = 'hidden';
	}
} 

function showLayer(layerRef, doc)
{ 
	var tempLayerName = layerRef;
	if (showLayer.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'showLayer()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, showLayer().");
		return;
	}

	if (inNetscape45) 
	{
		layerRef.visibility = 'show';
	}
	else if (inNetscape6)
	{
		if (layerRef.oldZIndex != null)
		{
			setLayerZIndex(layerRef, layerRef.oldZIndex, doc);
		}
		layerRef.style.visibility = 'visible';
	}
	else if (inIe4)
	{
		layerRef.style.visibility = 'visible';
	}
} 

function moveLayer(layerRef,x,y,doc)
{
	var tempLayerName = layerRef;
	if (moveLayer.arguments.length < 4)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'moveLayer()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, moveLayer().");
		return;
	}
		
	if (inNetscape45)
	{
		layerRef.left = x;
		layerRef.top = y;
	}
	else if (inNetscape6)
	{
		layerRef.style.left = x;
		layerRef.style.top = y;
	}
	else if (inIe4)
	{
		layerRef.style.pixelLeft = x;
		layerRef.style.pixelTop = y;
	}
}

function getLayerRef(layerName, doc)
{	
	var tempRef = null;
	if (getLayerRef.arguments.length < 2)
	{
		doc = document;
	}

	if ( typeof(layerName) != 'string' )
	{
		if (debugLayers)
			alert("Invalid argument to getLayerRef():\nlayerName needs to be a string.");
		return null;
	}

	if (inNetscape45) 
	{	
		recCount = 0;
		tempRef = getNestedLayer(layerName, doc);
		if ( typeof(tempRef) != 'object' )
		{
			return null;
		}
		else
		{
			return tempRef;
		}
	}
	else if (inNetscape6)
	{
		return doc.getElementById(layerName);
	}
	else if (inIe4)
	{
		tempRef = doc.all[layerName];
		if ( typeof(tempRef) != 'object' )
		{
			return null;
		}
		else
		{
			return tempRef;
		}
	}
	else
	{
		alert("Your current browser, " + navigator.appName + ", is not supported.");
		return null;
	}
}

function getLayerX(layerRef, doc)
{
	var tempLayerName = layerRef;
	if (getLayerX.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'getLayerX()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerX().");
		return 0;
	}
	
	if (inNetscape45) 
	{
		return layerRef.left;
	}
	else if (inNetscape6)
	{
		return layerRef.style.left;
	}
	else if (inIe4)
	{
		return layerRef.style.pixelLeft;
	}
}

function getLayerY(layerRef, doc)
{
	var tempLayerName = layerRef;
	if (getLayerY.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'getLayerY()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerY().");
		return 0;
	}
	
	if (inNetscape45) 
	{
		return layerRef.top;
	}
	else if (inNetscape6) 
	{
		return layerRef.style.top;
	}
	else if (inIe4) 
	{
		return layerRef.style.pixelTop;
	}
}

function checkLayerRef(layerRef, functionName, doc)
{
	if (checkLayerRef.arguments.length < 3)
	{
		doc = document;
	}

	if ( typeof(layerRef) == 'string' )
	{
		return getLayerRef(layerRef, doc);
	}
	else
	{
		if ( typeof(layerRef) != 'object')
		{
			if (debugLayers)
				alert("Invalid argument to checkLayerRef():\n"+functionName+" layerRef needs to be a string or a layer reference.");
			return null;
		}
	}
	return layerRef;
}

//getNestedLayer() is called by getLayerRef()
//in Netscape 4.5 only.
function getNestedLayer(layerName,doc)
{
	if (getNestedLayer.arguments.length < 2)
	{
		doc = document;
	}

	var value = null;
	
	if (recCount++ >= 100) 
	{
		return value;
	}
	
	for (var i=0;i<doc.layers.length;i++) // for each layer in the document
	{
		if (doc.layers[i].id == layerName) 
		{
			value = doc.layers[i];
			break;
		}
		else 
		{
			if (doc.layers[i].document.layers.length > 0) 
				if ( (value = getNestedLayer(layerName,doc.layers[i].document)) != null ) 
					break;
		}
	}
		
	return value;
}

function getLayerVisibility(layerRef, doc) 
{
	var tempLayerName = layerRef;
	if (getLayerVisibility.arguments.length < 2)
	{
		doc = document;
	}

	var value = false;
	layerRef = checkLayerRef(layerRef, 'getLayerVisibility()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerVisibility().");
		return false;
	}
	
	if (inNetscape45) 
	{
		if ( layerRef.visibility == 'inherit' ) 
		{
   			layerRef.visibility = 'show';
		}
   		if ( layerRef.visibility == 'show' ) 
   		{
   			value = true;
   		}
	}
	else if (inNetscape6)
	{
		if (layerRef.style.visibility == '')
		{
			layerRef.style.visibility = 'visible';
		}
		if (layerRef.style.visibility == 'visible')
		{
			value = true;
		}
	}
	else if (inIe4)
	{
		if (layerRef.style.visibility == '')
		{
			layerRef.style.visibility = 'visible';
		}
		if (layerRef.style.visibility == 'visible')
		{
			value = true;
		}
	}
	
	return value;
}

function getLayerWidth(layerRef, doc)
{
	var tempLayerName = layerRef;
	if (getLayerWidth.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'getLayerWidth()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerWidth().");
		return 0;
	}
	
	if (inNetscape45) 
	{
		return parseInt(layerRef.clip.width);
	}
	else if (inNetscape6)
	{
		return parseInt(layerRef.style.width);
	}
	else if (inIe4)
	{
		return parseInt(layerRef.style.width);
	}
}

function getLayerHeight(layerRef, doc)
{
	var tempLayerName = layerRef;
	if (getLayerHeight.arguments.length < 2)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'getLayerHeight()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, getLayerHeight().");
		return 0;
	}
	
	if (inNetscape45) 
	{
		return parseInt(layerRef.clip.height);
	}
	else if (inNetscape6)
	{
		return parseInt(layerRef.style.height);
	}
	else if (inIe4)
	{
		return parseInt(layerRef.style.height);
	}
}

function setLayerWidth(layerRef, width, doc)
{
	var tempLayerName = layerRef;

	if (setLayerWidth.arguments.length < 3)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'setLayerWidth()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, setLayerWidth().");
		return;
	}
	
	if (inNetscape45) 
	{
		layerRef.clip.width = width;
	}
	else if (inNetscape6)
	{
		layerRef.style.width = width;
	}
	else if (inIe4)
	{
		layerRef.style.width = width;
	}
}

function setLayerHeight(layerRef, height, doc)
{
	var tempLayerName = layerRef;
	if (setLayerHeight.arguments.length < 3)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'setLayerHeight()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, setLayerHeight().");
		return;
	}
	
	if (inNetscape45) 
	{
		layerRef.clip.height = height;
	}
	else if (inNetscape6)
	{
		layerRef.style.height = height;
	}
	else if (inIe4)
	{
		layerRef.style.height = height;
	}
}

function setLayerSize(layerRef, width, height, doc)
{
	var tempLayerName = layerRef;
	if (setLayerSize.arguments.length < 4)
	{
		doc = document;
	}

	layerRef = checkLayerRef(layerRef, 'setLayerSize()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, setLayerSize().");
		return;
	}
	
	if (inNetscape45) 
	{
		layerRef.clip.height = height;
		layerRef.clip.width = width;
	}
	else if (inNetscape6)
	{
		layerRef.style.height = height;
		layerRef.style.width = width;
	}
	else if (inIe4)
	{
		layerRef.style.height = height;
		layerRef.style.width = width;
	}
}

function setLayerVisibility(layerRef, flag, doc) 
{
	var tempLayerName = layerRef;
	if (setLayerVisibility.arguments.length < 3)
	{
		doc = document;
	}

	var value = false;
	layerRef = checkLayerRef(layerRef, 'setLayerVisibility()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, setLayerVisibility().");
		return;
	}
	
	if (inNetscape45) 
	{
		var temp;
		if (flag) temp = 'show';
		else temp = 'hide';
		
		layerRef.visibility = temp;
	}
	else if (inNetscape6)
	{
		var temp;
		if (flag) temp = 'visible';
		else temp = 'hidden';
		
		layerRef.style.visibility = temp;
	}
	else if (inIe4)
	{
		var temp;
		if (flag) temp = 'visible';
		else temp = 'hidden';
		
		layerRef.style.visibility = temp;
	}
	
}

function toggleLayerVisibility(layerRef, doc) 
{
	var tempLayerName = layerRef;
	if (toggleLayerVisibility.arguments.length < 2)
	{
		doc = document;
	}

	var value = false;
	layerRef = checkLayerRef(layerRef, 'toggleLayerVisibility()', doc);
	if (layerRef == null)
	{
		if (debugLayers)
			alert("cannot find layer, " + tempLayerName + ", in file, " + doc.location + ", in call to function, toggleLayerVisibility().");
		return;
	}
	
	if (inNetscape45) 
	{
		var temp;
		if (getLayerVisibility(layerRef, doc)) temp = 'hide';
		else temp = 'show';
		
		layerRef.visibility = temp;
	}
	else if (inNetscape6)
	{
		var temp;
		if (getLayerVisibility(layerRef, doc)) temp = 'hidden';
		else temp = 'visible';
		
		layerRef.style.visibility = temp;
	}
	else if (inIe4)
	{
		var temp;
		if (getLayerVisibility(layerRef, doc)) temp = 'hidden';
		else temp = 'visible';
		
		layerRef.style.visibility = temp;
	}
	
}

function getImageRef(imageName, doc)
{
	if (typeof imageName != "string")
	{
		if (debugLayers)
			alert("Error in call to getImageRef(imageName[,doc])\nimageName must be a string.");
		return null;
	}

	var imgRef = null;
	recCount = 0;
	if (getImageRef.arguments.length < 2)
	{
		doc = document;
	}
		
	imgRef = getImageRef2(imageName, doc);
	if (imgRef == null)
	{
		if (debugLayers)
			alert("cannot find image, " + imageName + ", in file, " + doc.location + ", in call to function, getImageRef().");
	}
	return imgRef;
}

function getImageRef2(imageName, doc)
{
	var imageRef = null;	
		
	// Base Case 1 - IE 4
	if (inIe4) 
	{
		imageRef = eval("doc.images['" + imageName + "']");
		return imageRef;
	}
	// Base Case 2 - Netscape 6
	else if (inNetscape6) 
	{
		imageRef = doc.getElementById(imageName);
		return imageRef;
	}
	// Base Case 3 - Netscape 4.5
	else if (inNetscape45)
	{
		if ( eval("doc.images['" + imageName + "']") != null )
		{
			imageRef = eval("doc.images['" + imageName + "']");
			return imageRef;
		}

		// Base Case 4 - Netscape45 Recursion limit
		if (recCount++ >= 100) 
		{
			return null;
		}

		// Possible Recursion for Netscape45.
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.images.length > 0)
			{
				if (doc.layers[i].document.images[imageName] != null) 
				{
					imageRef = doc.layers[i].document.images[imageName];
					return imageRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (imageRef = getImageRef2(imageName,doc.layers[i].document)) != null ) 
					break;
		}
		return imageRef;
	}
}

function getFormRef(formName, doc)
{
	if (typeof formName != "string")
	{
		if (debugLayers)
			alert("Error in call to getFormRef(formName[,doc])\nformName must be a string.");
		return null;
	}

	var frmRef = null;
	recCount = 0;
	if (getFormRef.arguments.length < 2)
	{
		doc = document;
	}
		
	frmRef = getFormRef2(formName, doc);
	if (frmRef == null)
	{
		if (debugLayers)
			alert("cannot find form, " + formName + ", in file, " + doc.location + ", in call to function, getFormRef().");
	}
	return frmRef;
}

function getFormRef2(formName, doc)
{
	var formRef = null;	
		
	// Base Case 1 - IE 4
	if (inIe4) 
	{
		formRef = eval("doc.forms['" + formName + "']");
		return formRef;
	}
	// Base Case 2 - Netscape 6
	else if (inNetscape6) 
	{
		formRef = doc.getElementById(formName);
		return imageRef;
	}
	// Base Case 3 - Netscape 4.5
	else if (inNetscape45)
	{
		if ( eval("doc.forms['" + formName + "']") != null )
		{
			formRef = eval("doc.forms['" + formName + "']");
			return formRef;
		}

		// Base Case 4 - Netscape45 Recursion limit
		if (recCount++ >= 100) 
		{
			return null;
		}

		// Possible Recursion for Netscape45.
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.forms.length > 0)
			{
				if (doc.layers[i].document.forms[formName] != null) 
				{
					formRef = doc.layers[i].document.forms[formName];
					return formRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (formRef = getFormRef2(formName,doc.layers[i].document)) != null ) 
					break;
		}
		return formRef;
	}
}

